package com.hero.objects.modifiers;

import java.util.ArrayList;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Entangle;
import com.hero.objects.powers.ForceWall;
import com.hero.objects.powers.MindControl;
import com.hero.objects.powers.Telepathy;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class TimeLimit extends Modifier {

	private static String xmlID = "TIMELIMIT";

	public TimeLimit(Element root) {
		super(root, TimeLimit.xmlID);
	}
	
	

	@Override
	public String getColumn2Output() {
		String ret = getAlias().trim();
		if (getSelectedOption() != null && getSelectedOption().getAlias().trim().length()>0) {
			ret += " ("+getSelectedOption().getAlias().trim();
			if (getInput() != null && getInput().trim().length()>0) {
				ret += ", "+getInput().trim();
			}
			if (getComments() != null && getComments().trim().length()>0) {
				ret += ", "+getComments().trim();
			}
			ret += "; "+getFraction(getTotalValue())+")";
		} else {
			ret += " ("+getFraction(getTotalValue())+")";
		}
		return ret;
	}



	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		if (!(o.getDuration().equals("PERSISTENT")
				|| o.getDuration().equals("CONSTANT") || o.getDuration()
				.equals("INSTANT"))) {
			return getDisplay()
					+ " can only be applied to Persistent, Constant, or Instant Powers";
		}
		if (o.usesEND() && !o.getDuration().equals("INSTANT")) {
			if (findObjectByID(o.getAssignedModifiers(), "COSTSENDONLYTOACTIVATE") != null) {
				return "";
			} else if (findObjectByID(o.getAssignedModifiers(), "COSTSEND") != null) {
				GenericObject go = findObjectByID(o.getAssignedModifiers(),
						"COSTSEND");
				if (go.getSelectedOption() != null
						&& go.getSelectedOption().getXMLID().equals("ACTIVATE")) {
					return "";
				}
			}
			return getDisplay() + " can only be applied to abilities "
					+ "which cost 0 END or which cost END only to activate";
		}
		return "";
	}

	private ArrayList<Adder> getLimitationTable() {
		ArrayList<Adder> ops = new ArrayList<Adder>();
		Adder op = new Adder();
		op.setDisplay("Extra Phase");
		op.setBaseCost(-3);
		op.setXMLID("EXTRAPHASE");
		ArrayList<String> exs = new ArrayList<String>();
		exs.add("");
		exs.add("+1 Phase per point the Skill Roll succeeds by");
		op.setExamples(exs);
		ops.add(op);
		op = new Adder();
		op.setDisplay("1 Turn");
		op.setBaseCost(-2.5);
		op.setXMLID("1TURN");
		exs = new ArrayList<String>();
		exs.add("");
		exs.add("+1 Turn per point the Skill Roll succeeds by");
		op.setExamples(exs);
		ops.add(op);
		op = new Adder();
		op.setDisplay("1 Minute");
		op.setBaseCost(-2);
		op.setXMLID("1MINUTE");
		exs = new ArrayList<String>();
		exs.add("");
		exs.add("+1 Minute per point the Skill Roll succeeds by");
		op.setExamples(exs);
		ops.add(op);
		op = new Adder();
		op.setDisplay("5 Minutes");
		op.setBaseCost(-1.5);
		op.setXMLID("5MINUTES");
		exs = new ArrayList<String>();
		exs.add("");
		exs.add("+5 Minutes per point the Skill Roll succeeds by");
		op.setExamples(exs);
		ops.add(op);
		op = new Adder();
		op.setDisplay("20 Minutes");
		op.setBaseCost(-1);
		op.setXMLID("20MINUTES");
		exs = new ArrayList<String>();
		exs.add("");
		exs.add("+20 Minutes per point the Skill Roll succeeds by");
		op.setExamples(exs);
		ops.add(op);
		op = new Adder();
		op.setDisplay("1 Hour");
		op.setBaseCost(-.75);
		op.setXMLID("1HOUR");
		exs = new ArrayList<String>();
		exs.add("");
		exs.add("+1 Hour per point the Skill Roll succeeds by");
		op.setExamples(exs);
		ops.add(op);
		op = new Adder();
		op.setDisplay("6 Hours");
		op.setBaseCost(-.5);
		op.setXMLID("6HOURS");
		exs = new ArrayList<String>();
		exs.add("");
		exs.add("+6 Hours per point the Skill Roll succeeds by");
		op.setExamples(exs);
		ops.add(op);
		op = new Adder();
		op.setDisplay("1 Day");
		op.setBaseCost(-.25);
		op.setXMLID("1DAY");
		exs = new ArrayList<String>();
		exs.add("");
		exs.add("+1 Day per point the Skill Roll succeeds by");
		op.setExamples(exs);
		ops.add(op);
		op = new Adder();
		op.setDisplay("1 Week");
		op.setBaseCost(0);
		op.setXMLID("1WEEK");
		exs = new ArrayList<String>();
		exs.add("");
		exs.add("+1 Week per point the Skill Roll succeeds by");
		op.setExamples(exs);	
		ops.add(op);
		return ops;
	}
	@Override
	public void setParent(GenericObject pVal) {
		super.setParent(pVal);
		ArrayList<Adder> ops = new ArrayList<Adder>();
		if (pVal == null) {
			setOptions(ops);
			return;
		}
		if (pVal.getDuration().equals("INSTANT")) {
			if (pVal instanceof Telepathy || pVal instanceof MindControl
					|| pVal instanceof Entangle || pVal instanceof ForceWall) {
				//limitation table
				ops = getLimitationTable();
			} else {
				//instant advantage
				Adder op = new Adder();
				op.setDisplay("Extra Phase");
				op.setBaseCost(.25);
				op.setXMLID("EXTRAPHASE");
				ArrayList<String> exs = new ArrayList<String>();
				exs.add("");
				exs.add("+1 Phase per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("1 Turn");
				op.setBaseCost(.5);
				op.setXMLID("1TURN");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+1 Turn per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("1 Minute");
				op.setBaseCost(.75);
				op.setXMLID("1MINUTE");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+1 Minute per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("5 Minutes");
				op.setBaseCost(1);
				op.setXMLID("5MINUTES");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+5 Minutes per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("20 Minutes");
				op.setBaseCost(1.25);
				op.setXMLID("20MINUTES");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+20 Minutes per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("1 Hour");
				op.setBaseCost(1.5);
				op.setXMLID("1HOUR");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+1 Hour per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("6 Hours");
				op.setBaseCost(1.75);
				op.setXMLID("6HOURS");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+6 Hours per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("1 Day");
				op.setBaseCost(2);
				op.setXMLID("1DAY");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+1 Day per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("1 Week");
				op.setBaseCost(2.25);
				op.setXMLID("1WEEK");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+1 Week per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("1 Month");
				op.setBaseCost(2.5);
				op.setXMLID("1MONTH");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+1 Month per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("1 Season");
				op.setBaseCost(2.75);
				op.setXMLID("1SEASON");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+1 Season per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("1 Year");
				op.setBaseCost(3);
				op.setXMLID("1YEAR");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+1 Year per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("5 Years");
				op.setBaseCost(3.25);
				op.setXMLID("5YEARS");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+5 Years per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("25 Years");
				op.setBaseCost(3.5);
				op.setXMLID("25YEARS");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+25 Years per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
				op = new Adder();
				op.setDisplay("1 Century");
				op.setBaseCost(3.75);
				op.setXMLID("1CENTURY");
				exs = new ArrayList<String>();
				exs.add("");
				exs.add("+1 Century per point the Skill Roll succeeds by");
				op.setExamples(exs);
				ops.add(op);
			}
		} else if (pVal.getDuration().equals("CONSTANT")) {
			Adder op = new Adder();
			op.setDisplay("1 Turn");
			op.setBaseCost(.25);
			op.setXMLID("1TURN");
			ArrayList<String> exs = new ArrayList<String>();
			exs.add("");
			exs.add("+1 Turn per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("1 Minute");
			op.setBaseCost(.5);
			op.setXMLID("1MINUTE");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+1 Minute per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("5 Minutes");
			op.setBaseCost(.75);
			op.setXMLID("5MINUTES");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+5 Minutes per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("20 Minutes");
			op.setBaseCost(1);
			op.setXMLID("20MINUTES");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+20 Minutes per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("1 Hour");
			op.setBaseCost(1.25);
			op.setXMLID("1HOUR");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+1 Hour per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("6 Hours");
			op.setBaseCost(1.5);
			op.setXMLID("6HOURS");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+6 Hours per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("1 Day");
			op.setBaseCost(1.75);
			op.setXMLID("1DAY");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+1 Day per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("1 Week");
			op.setBaseCost(2);
			op.setXMLID("1WEEK");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+1 Week per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("1 Month");
			op.setBaseCost(2.25);
			op.setXMLID("1MONTH");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+1 Month per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("1 Season");
			op.setBaseCost(2.5);
			op.setXMLID("1SEASON");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+1 Season per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("1 Year");
			op.setBaseCost(2.75);
			op.setXMLID("1YEAR");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+1 Year per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("5 Years");
			op.setBaseCost(3);
			op.setXMLID("5YEARS");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+5 Years per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("25 Years");
			op.setBaseCost(3.25);
			op.setXMLID("25YEARS");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+25 Years per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
			op = new Adder();
			op.setDisplay("1 Century");
			op.setBaseCost(3.5);
			op.setXMLID("1CENTURY");
			exs = new ArrayList<String>();
			exs.add("");
			exs.add("+1 Century per point the Skill Roll succeeds by");
			op.setExamples(exs);
			ops.add(op);
		} else if (pVal.getDuration().equals("PERSISTENT")) {
			//persistent limitation
			ops = getLimitationTable();
		}
		setOptions(ops);
		if (getSelectedOption() == null && ops != null && ops.size()>0) {
			setSelectedOption(ops.get(0));
		} else if (ops != null && ops.size()>0){
			GenericObject o = findObjectByID(ops, getSelectedOption().getXMLID());
			if (o == null) {
				setSelectedOption(ops.get(0));
			} else {
				getSelectedOption().setBaseCost(o.getBaseCost());
			}
		}
	}

}